﻿using Microsoft.Web.Http;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderNetworksController : ODataController
    {
        [ODataRoute("ProviderNetworks({key})")]
        public async Task<HttpResponseMessage> Get(int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //look up the network id in model. 
                //var network = NetworkIds.GetNetwork(key);
                //Retrieve the Provider Network
                var ppmsProviderNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == key);
                if (ppmsProviderNetwork != null)
                {
                    var ppmsProviderNetworkList = new List<ppms_vaprovidernetwork> { ppmsProviderNetwork };
                    var providerNetwork = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworkList, queryType, context);
                    return Request.CreateResponse(providerNetwork);
                }
            }
            var message = string.Format("No VA Provider Network found for given Network Id");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderNetworks({key})/ProviderServices")]
        public async Task<HttpResponseMessage> GetProviderServices(int key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //look up the network id in model. 
                //var network = NetworkIds.GetNetwork(key);
                //Retrieve the Provider Network
                var ppmsProviderNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == key);
                if (ppmsProviderNetwork != null)
                {
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_network.Id == ppmsProviderNetwork.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("No Provider Services found for given Network Id");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }


        [ODataRoute("ProviderNetworks")]
        public async Task<HttpResponseMessage> Get()
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Networks 
                var ppmsProviderNetworks = context.ppms_vaprovidernetworkSet
                    .Where(i => i.ppms_name != null && i.StatusCode.Value == (int)ppms_vaprovidernetwork_StatusCode.Active).Take(50);
                var ppmsProviderNetworksList = ppmsProviderNetworks.ToList();
                if (ppmsProviderNetworksList.Any())
                {
                    var providerNetworks = await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworksList, queryType, context);
                    return Request.CreateResponse(providerNetworks);
                }
            }
            var message = string.Format("Provider Networks Not Found");
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }



    }
}